#!/usr/bin/perl -U

# I'm going to throw the JSI copyright on this puppy.
#                           jsm, 21 Novembre 1996

# Following the information in David O'Brien's article in the November 1996 Sys Admin magazine
# and information i've gleened from reading rootkit source.

# Most of the checks will only catch the stupid ones, because they check for defaults
# that the kits set.  Obviously, any smart fellow will change the defaults.  The only
# checks that will work in that case are those that check kernel-level information,
# like processes and the promiscuity of the ethernet interface(s).

# The defaults from the kits are as follow:
#
#       magic passwords: "lrkr0x", "D13hh[", or "fasune" (work for login).
#       magic user: "rewt".
#       config files: /dev/ptyX, where X is a lowercase character
#       install/tmp directories: "/usr/5bin/..." and "/tmp/.X11-unix/..."
#       Trojan programs: ls, ps, du, netstat, ifconfig, top, automount, si?
#       odd flags for Trojan programs: "-/"

require 'rkd_conf.pl';

$uname = `uname -sr`;
chop $uname;

if ($uname =~ /IRIX/) {
    print "** You appear to be an IRIX box **\n";
    $package = "_irix";
} elsif ($uname =~ /SunOS/) {
    print "** You appear to be a Sun box **\n";
    $package = "_sun";
} elsif ($uname =~ /FreeBSD/) {
    print "** You appear to be a FreeBSD box **\n";
    $package = "_freebsd";
} else {
    print "** Libraries have not been built for $uname boxen **\n";
    undef $package;
}

$rkd_lib = "rkd_lib" . $package . ".pl";

require $rkd_lib;

if ($uname =~ /(IRIX|SunOS 5)/) {
    $SOCK_DGRAM = 1;		# UDP
    $SOCK_STREAM = 2;		# TCP
    $SOCK_RAW = 4;		# ICMP -- needs root privs
} else {
    $SOCK_DGRAM = 2;		# UDP
    $SOCK_STREAM = 1;		# TCP
    $SOCK_RAW = 3;		# ICMP -- needs root privs
}

if ($uname =~ /Cray/) { 
    $sockaddr = 'I N a4 x20';	# Cray
} else {
    $sockaddr = 'S n a4 x8';	# The rest of the world
}

$AF_INET = 2;

##
## Do the sundry checks
##

&command_chk();
&pw_check();
&bindshell_chk();
&promisc_check();
&dev_check();
&sun_dir_check();
&dotdotdot_check();

# check utmp, wtmp, and lastlog for zeroed entries

# read the process table and compare that with the processes "ps" reports.

print "### FIN ###\n";
exit 0;

##
## Sub-routines
##

# Check magic passwords and users
sub pw_check {
    foreach $i (@magic_passwords) {
	my $telnet_login_chk = $package . "'telnet_login_chk";
	print "### Checking $i as a password for root ###\n\n";
	    &$telnet_login_chk('root', $i, `hostname`);
    
#    &doconnect("23", 60, 'my_telnet_login_chk', 'root', $i);    # works on IRIX, not on Sun

#    print "### Checking $i as a user for rsh ###\n";
#    $result = "\n\t";
#    $result .= `rsh localhost -l $i whoami 2>&1` . "\n";
#    print $result;
    }

    foreach $i (@magic_users) {
	foreach $j (@magic_passwords) {
	    print "### Checking $j as a password for $i ###\n";
		#&doconnect("telnet", 60, 'login_chk', $i, $j);
	    }
    }

}

# Do some checks on /dev
sub dev_check {
    local($check_dev);

# look for text files in /dev
    print "### Non-special files in /dev ###\n\n";

    $check_dev = 'require "find.pl";' .
	"&find('/dev');" .
	"sub wanted {" .
	    "((\$dev,\$ino,\$mode,\$nlink,\$uid,\$gid) = lstat(\$_)) &&" .
	      "-f _ &&" .
	     'print("\t$name\n\t\tSize: ", -s, "\n\t\tLast modified ",'.
		 'int(-M), " days ago\n\t\tCreated ", int(-C), " days ago\n");' .
        "}";

    eval($check_dev);

    print "\n";

# list any /dev/ptyX files, where X is a lowercase letter
    print "### /dev/ptyX files ###\n\n";
    
    $check_dev = 'require "find.pl";' .
	"&find('/dev');" .
	"sub wanted {" .
	     "/^pty.\$/ &&" .
	     'print("\t$name\n\t\tSize: ", -s, "\n\t\tLast modified ",'.
		 'int(-M), " days ago\n\t\tCreated ", int(-C), " days ago\n");' .
        "}";

    eval($check_dev);

    print "\n";

# list any /dev/pts/ directories
# These seems awfully SUNny, so we'll limit it
    if ($package eq "_sun") {
	print "### /dev/pts directories ###\n\n";
    
	    $check_dev = 'require "find.pl";' .
		"&find('/dev/pts');" .
		"sub wanted {" .
		"((\$dev,\$ino,\$mode,\$nlink,\$uid,\$gid) = lstat(\$_)) &&" .
		"-d _ &&" . 
		'print("\t$name\n\t\tSize: ", -s, "\n\t\tLast modified ",'.
		'int(-M), " days ago\n\t\tCreated ", int(-C), " days ago\n");' .
		"}";

	eval($check_dev);

	print "\n";
    }

}

# The Sun rootkit mentions a couple of directories in its Makefile
# The right way to do this is to do a find of the entire file-system
#     for any "..." directories.
sub sun_dir_check {
    local($check_sun);

    foreach (@secretfiles) {
	
	print "\t$_\n\t\tSize: ", -s, "\n\t\tLast modified ", int(-M), " days ago\n\t\tCreated ", 
              int(-C), " days ago\n" if -e;

    }

    print "\n";
}

sub dotdotdot_check {
    my $fs;

# We're just going to search the entire system for "..." or ".\s+" files
    print "### '...' and '. '  directories ###\n\n";
    
# Do this better... get the non-NFS filesystems via mount(8), then fork
#   off the evals. If you can duplicate getvfsent, that's a win, too.

    my $get_filesystems = $package . "'get_filesystems";
    my @fs = &$get_filesystems;

    foreach $fs (@fs) {
	my $check_dotdotdot = 'require "find.pl";' .
	    "&find('$fs');" .
	    "sub wanted {" .
	    "((\$dev,\$ino,\$mode,\$nlink,\$uid,\$gid) = lstat(\$_)) && " .
	    "!(\$prune |= (\$dev != \$topdev)) && " .
	    "-d _ && " . 
	    '/^(\.\.\.|\.\s+)$/ && ' .
	    'print("\t\"$name\"\n\t\tSize: ", -s, "\n\t\tLast modified ",'.
	    'int(-M), " days ago\n\t\tCreated ", int(-C), " days ago\n");' .
	    "}";

	eval($check_dotdotdot);
    }

    print "\n";

}

sub bindshell_chk {
    foreach $bindshell_port (@bindshell_ports) {
	print "### Checking for bindshell at $bindshell_port ###\n\n";
	&doconnect($bindshell_port, 60);
	print "\n";
    }
}

sub command_chk {
    local ($i, $result);
    foreach $i (@trojan_progs) {
	print "### Checking $i for the -/ flag ###\n\n";
        my $true_results = `$i -/ 2>&1`;
	$true_results = "This may be a Trojan!\n" if !$true_results;    
	$result = "\t" . $true_results;
	$result =~ s/\n/\n\t/g;
	$result .= "\n";
	print $result;
    }
}

# do the promisc check
sub promisc_check {
    print "### Checking to see if a network interface is in PROMISC mode ###\n";
## Sun doesn't report promiscuous mode, even when snoop or tcpdump is running.
##    this seems to be a function of the STREAMS module.
    if ($uname =~ /SunOS 5/) {
	print "#### Note: Solaris 2.6 and up will *always* report non-promiscuous #####\n";
    } else {

	print "\n";
	foreach $i (&interfaces()) {
	    print "checking $i\n";
	    &vice_check($i, );     # not working
#    &vice_check("lo0", );
	}
    }

}

##
## Utility subroutines
##

sub doconnect {
    local ($port, $timeout, $sub, $aname, $apass) = @_;
    local ($name,$aliases,$type,$len,$thisaddr,$thataddr,$proto,$connect_stat,$hostname);
    $SIG{'ALRM'} = 'doalarm';
    $SIG{'PIPE'} = 'dopipe';

    $hostname = `hostname`;
    chop $hostname;

    if ($sub && $package) {
	$sub = $package . "'$sub";
    }

    ($name,$aliases,$proto) = getprotobyname('tcp');
    ($name,$aliases,$port) = getservbyname($port,'tcp')
	unless $port =~ /^\d+$/;;
    ($name,$aliases,$type,$len,$thisaddr) = gethostbyname($hostname);
    ($name,$aliases,$type,$len,$thataddr) = gethostbyname($hostname);

    $this = pack($sockaddr, $AF_INET, 0, $thisaddr);
    $that = pack($sockaddr, $AF_INET, $port, $thataddr);
	
    # Make sock filehandle

    if (socket(S, $AF_INET, $SOCK_STREAM, $proto)) {
	print "sock ok\n" if $debug;
    }
    else {
	warn $!;
	return;
    }

    # give the socket an address

    if (bind(S, $this)) {
	print "good bind\n" if $debug;
    }
    else {
	warn $!;
	return;
    }
    alarm $timeout;
    $connect_stat = connect(S,$that);
    
    print "\n\tConnection made\n" if $connect_stat;

    undef $sub_results;

    if ($connect_stat && $sub) {
	print "running $sub\n";
	local ($sub_results) = &$sub($aname, $apass, \*S);
    }

    alarm 0;
    close S;
    shutdown(S, 2);

    return $connect_stat;
}

sub interfaces {
    local(*FD);
    my $if;
    my $foo;
    my @ifs;

#    open(FD, "/sbin/ifconfig -l|") || return $?;
    open(FD, "/sbin/ifconfig -au |") || return $?;

    while (<FD>) {
	if (/^([\w\d]*):/) {
	    $if = $1;
	    push @ifs, $if;
	}
    }
    return @ifs;
}

#use Sys::Hostname;

# check for promiscuity
sub vice_check {
# look for our e-net interface in promiscous mode
    my ($interface) = @_;

    my $SIOCGIFFLAGS = $package . "'SIOCGIFFLAGS";
    my $IFF_PROMISC = $package . "'IFF_PROMISC";

#    my $hostname = hostname();

#	print "$hostname\n";

# SGI Promiscuous mode is 
#
#    #define IFF_PROMISC     0x100           /* receive all packets */
#
# SUN is
#
#    #define IFF_PROMISC     0x100           /* receive all packets */
#
# These are part of ifnet->if_flags.
#
# (The above from <net/if.h>)

# The clever boys who write the rootkit remove PROMISC from the IFFBITS in the source.
# They note that strings(1) won't show that string.

# get the ifreq structure.  Fill it from the socket.  Look at ifreq.ifru.ifru_flags.


    $IFNAMSIZ = 16;
    $ifreq = 'a16 S';

    $ifreq_struct = pack($ifreq, $interface);

    ($name,$aliases,$proto) = getprotobyname('udp');
#    ($name,$aliases,$type,$len,$thisaddr) = gethostbyname("$hostname");
#    ($name,$aliases,$type,$len,$thisaddr) = gethostbyname('localhost');
#    ($name,$aliases,$type,$len,$thisaddr) = gethostbyname('up');
#    $this = pack($sockaddr, $AF_INET, 0, $thisaddr);

    socket(FD, $AF_INET, $SOCK_DGRAM, $proto) or (print STDERR "socket: $!" 
						  and return -1);

    (($retval = ioctl(FD, &$SIOCGIFFLAGS, $ifreq_struct)) or 
     (($retval = -1)) and
	 $! and 
	     (print STDERR "ioctl returned $retval, ERRNO = "  .  int($!) . " -- $!\n" and 
	      return -1));

    ($iname,$if_flag) = unpack($ifreq, $ifreq_struct);
    
#     printf("%s: flags=%x<", $iname, $if_flag);
#     print "UP " if $if_flag & &IFF_UP;
#     print "BROADCAST " if $if_flag & &IFF_BROADCAST;
#     print "DEBUG " if $if_flag & &IFF_DEBUG;
#     print "LOOPBACK " if $if_flag & &IFF_LOOPBACK;
#     print "POINTOPOINT " if $if_flag & &IFF_POINTOPOINT;
#     print "NOTRAILERS " if $if_flag & &IFF_NOTRAILERS;
#     print "RUNNING " if $if_flag & &IFF_RUNNING;
#     print "NOARP " if $if_flag & &IFF_NOARP;
#     print "PROMISC " if $if_flag & &IFF_PROMISC;
#     print "ALLMULTI " if $if_flag & &IFF_ALLMULTI;
#     print "FILTMULTI " if $if_flag & &IFF_FILTMULTI;
#     print "INTELLIGENT " if $if_flag & &IFF_INTELLIGENT;
#     print "MULTICAST " if $if_flag & &IFF_MULTICAST;
#     print "CKSUM " if $if_flag & &IFF_CKSUM;
#     print "ALLCAST " if $if_flag & &IFF_ALLCAST;
#     print "PRIVATE" if $if_flag & &IFF_PRIVATE;
#     print ">\n";

    print "\t$iname: PROMISC\n" if $if_flag & &$IFF_PROMISC;
    close (FD);
}

##
## undeveloped subroutines
##

# our own ls, just in case they've foo'd the system version
sub ls {
}

sub doalarm {
    print STDERR "Connection failed\n";
}

sub dopipe {
    print STDERR "Broken pipe.\n";
}
