#!/usr/locl/bin/perl

package _freebsd;

$du = '/usr/bin/du';
$netstat = '/usr/bin/netstat';
$login = '/usr/bin/login';
$mount_command = '/sbin/mount -p';

sub IFF_UP {0x1;};
sub IFF_BROADCAST {0x2;};
sub IFF_DEBUG {0x4;};
sub IFF_LOOPBACK {0x8;};
sub IFF_POINTOPOINT {0x10;};
sub IFF_NOTRAILERS {0x20;};
sub IFF_RUNNING {0x40;};
sub IFF_NOARP {0x80;};
sub IFF_PROMISC {0x100;};
sub IFF_ALLMULTI {0x200;};
sub IFF_FILTMULTI {0x400;};
sub IFF_INTELLIGENT {0x400;};
sub IFF_MULTICAST {0x800;};
sub IFF_CKSUM {0x1000;};
sub IFF_ALLCAST {0x2000;};
sub IFF_PRIVATE {0x8000;};
sub IFF_CANTCHANGE {( &IFF_BROADCAST | &IFF_POINTOPOINT | &IFF_RUNNING | &IFF_MULTICAST | &IFF_FILTMULTI);};

sub IOCPARM_MASK {0x1fff;};
sub IOC_OUT {0x40000000;};
sub IOC_IN {0x80000000;};
sub IOC_INOUT {( &IOC_IN| &IOC_OUT);};

sub _IOC {
    local($inout,$group,$num,$len) = @_;
    eval q((($inout | (($len &  &IOCPARM_MASK) << 16) | (($group) << 8) | ($num))));
}

sub _IOWR {
    local($g,$n,$t) = @_;
    eval q( &_IOC( &IOC_INOUT, ($g), ($n), ($t)));
#    eval "(((&_IOC_INOUT)|((($t)& &_IOCPARM_MASK)<<16)|(($x)<<8)|($y)))";
};

sub SIOCGIFFLAGS { &_IOWR(ord('i'), 17, 32);};

sub login_chk {
    my($aname, $apass) = @_;
    my $result;
    local *LOGIN;

    print "using $apass for $aname in FreeBSD login_chk\n";

    $apass .= "\r\n";

    print "opening $login $aname|\n";
    open (LOGIN, "cat /etc/motd|") or die "Kinna open $login\n";

    select(LOGIN); $| = 1; select(STDOUT);

    while (<LOGIN>) {
	print;
#	print LOGIN "$apass";
    }
}

sub my_telnet_login_chk {
    local($aname, $apass, $S) = @_;
    local($result);

    $aname .= "\r\n";
    $apass .= "\r\n";


    select($S); $| = 1; select(STDOUT);

#    print $S "\377\370";
#0x0000   fffd 26                DO ENCRYPT
#0x0003   fffb 26                WILL ENCRYPT
#0x0006   fffd 03                DO SUPPRESS GO AHEAD
#0x0009   fffb 18                WILL TERMINAL TYPE
#0x000c   fffb 1f                WILL NAWS
#0x000f   fffb 20                WILL TSPEED
#0x0012   fffb 21                WILL LFLOW
#0x0015   fffb 22                WILL LINEMODE
#0x0018   fffb 27                WILL NEW-ENVIRON
#0x001b   fffd 05                DO STATUS
#0x001e   fffb 23                WILL XDISPLOC
#SENT WILL AUTHENTICATION
#SENT DO ENCRYPT
#SENT WILL ENCRYPT
#SENT DO SUPPRESS GO AHEAD
#SENT WILL TERMINAL TYPE
#SENT WILL NAWS
#SENT WILL TSPEED
#SENT WILL LFLOW
#SENT WILL LINEMODE
#SENT WILL NEW-ENVIRON
#SENT DO STATUS
#SENT WILL XDISPLOC
    # send "This is a command, are you there?, end of record"
    print $S "\377\366\357\n";
    recv($S, $result, 128, 0);
#    $result =~ s/\375/\374/g;
#    $result =~ s/\373/\376/g;
    print join(" ", unpack("C*", $result));
#    print $result;


#    print "Doing freebsd login_chk\n";

    $/ = ': ';
    while (<$S>) {
	print "reading\n$_";
	last if /^login/;
    }

    $/ = '\n';

    $sent = send($S, $aname, 0);

    send ($S, $apass, 0);

    sleep 5;
    recv($S, $result, 1024, 0);

    $result =~ s/\n/\n\t/g;
    $result .= "\n\n";

    print $result;

    return $result;
}

# get filesystems
sub get_filesystems {
    my @fs;

    # open mount -p
    open (MOUNT, "$mount_command |") or (warn "Kinna open $mount_command\n" && return @fs);
    while (<MOUNT>) {
	my ($fs, $mp, $fstype) = split;
	push @fs, $mp if ( $fstype ne "nfs");
    }
    close MOUNT;

    return @fs;
}


use Net::Telnet;

sub telnet_login_chk {
    my($aname, $apass, $ahost) = @_;
    my $result;

    my $t = new Net::Telnet (Errmode => 'return');

    $t->open($ahost);
    my $ok = $t->login($aname, $apass);

    if ($ok) {
        print "\t$apass is a valid password for $auser\n\n";
    } else {
        print "\tNo login\n\n";
    }

    return $ok;
}

1;
